# forms.py
from django import forms
from .models import Post, Comment, Book, Video


class PostForm(forms.ModelForm):
    class Meta:
        model = Post
        fields = ['title', 'content']  # Solo campos editables


class CommentForm(forms.ModelForm):
    class Meta:
        model = Comment
        fields = ['content']  # Solo campo editable

class BookForm(forms.ModelForm):
    class Meta:
        model = Book
        fields = ['title', 'file']


class VideoForm(forms.ModelForm):
    class Meta:
        model = Video
        fields = ['title', 'youtube_url']        