from django.db.models.signals import post_save
from django.dispatch import receiver
from django.core.mail import send_mail
from django.conf import settings
from social.models import News, Comment
from scouts.models import Scout
from scouts.models import Notification


@receiver(post_save, sender=News)
def create_news_notification(sender, instance, created, **kwargs):
    if created:
        scouts = Scout.objects.all()  # Notificar a todos los scouts
        for scout in scouts:
            Notification.objects.create(
                user=scout.user,
                message=f"Nueva noticia publicada: {instance.title}",
                type='general',
                status='unread'
            )
            # Enviar correo
            send_mail(
                subject="Nueva Noticia en AgriCarm",
                message=f"Hola {scout.first_name},\n\nSe ha publicado una nueva noticia: {instance.title}.\n\nRevisa tu cuenta para más detalles.",
                from_email=settings.DEFAULT_FROM_EMAIL,
                recipient_list=[scout.email],
            )


@receiver(post_save, sender=Comment)
def create_comment_notification(sender, instance, created, **kwargs):
    if created:
        post_author = instance.post.author
        if post_author:
            # Crear notificación
            Notification.objects.create(
                user=post_author.user,
                message=f"Nuevo comentario en tu publicación {instance.post.title}",
                type='general',
                status='unread'
            )
            # Enviar correo
            send_mail(
                subject="Nuevo Comentario en AgriCarm",
                message=f"Hola {post_author.first_name},\n\nSe ha agregado un nuevo comentario a tu publicación {instance.post.title}.\n\nRevisa tu cuenta para más detalles.",
                from_email=settings.DEFAULT_FROM_EMAIL,
                recipient_list=[post_author.email],
            )
