from django.db import models
from agronomist.models import Agronomist
from scouts.models import Scout
from django.contrib.auth.models import User
from django.db.models.signals import post_save
from django.dispatch import receiver
from ckeditor.fields import RichTextField



class News(models.Model):
    title = models.CharField(max_length=255)
    content = RichTextField()  # Esto permite un editor enriquecido con HTML
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    author = models.ForeignKey(
        Agronomist, on_delete=models.SET_NULL, null=True, blank=True)

    def __str__(self):
        return self.title

    class Meta:
        verbose_name = "Noticia"
        verbose_name_plural = "Noticias"
