from django.contrib import admin
from django.db import models  # Asegúrate de importar esto
# Importa el widget de CKEditor si lo estás usando
from ckeditor.widgets import CKEditorWidget
from .models import News


@admin.register(News)
class NewsAdmin(admin.ModelAdmin):
    list_display = ('title', 'created_at')
    formfield_overrides = {
        # Cambia AdminCKEditorWidget por CKEditorWidget
        models.TextField: {'widget': CKEditorWidget},
    }
