"""
Django settings for agroapp project.

Generated by 'django-admin startproject' using Django 5.0.6.

For more information on this file, see
https://docs.djangoproject.com/en/5.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.0/ref/settings/
"""

import os
from os.path import join
from pathlib import Path
from django.utils.translation import gettext_lazy as _


# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-k-!f&)tat#*xzs8c-rr)6-9rom+_+n568xqph&bwsxi^+k!bk0'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions.backends.db',
    'django.contrib.sessions',
    # 'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.humanize',
    'whitenoise.runserver_nostatic',
    'scouts',  # Añade tu app Scout
    'social',
    'agronomist',
    'farmer',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',  # Asegúrate de tener esto
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.locale.LocaleMiddleware',  # Está en el lugar adecuado aquí
]


ROOT_URLCONF = 'agroapp.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': ['/home/agricarm.com/public_html/agroapp/agroapp/templates'],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'django.template.context_processors.i18n',  # Context processor para i18n                
                'agroapp.context_processors.notifications_context',
                'agroapp.context_processors.current_user_context',
            ],
        },
    },
]

WSGI_APPLICATION = 'agroapp.wsgi.application'

# Database
# https://docs.djangoproject.com/en/5.0/ref/settings/#databases
# 

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'agroapp.sqlite3'),  # Asegúrate de que este sea el archivo correcto
    }
}

# Password validation
# https://docs.djangoproject.com/en/5.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
        },
    },
    'root': {
        'handlers': ['console'],
        'level': 'DEBUG',
    },
}

# Internationalization
# https://docs.djangoproject.com/en/5.0/topics/i18n/

# Idioma predeterminado
LANGUAGE_CODE = 'es'

# Formato de fecha y otras configuraciones en español
USE_I18N = True
USE_L10N = True
USE_TZ = True

USE_L10N = True
DECIMAL_SEPARATOR = ','
USE_THOUSAND_SEPARATOR = True
THOUSAND_SEPARATOR = '.'
NUMBER_GROUPING = 3

USE_TZ = True


# Definir los idiomas disponibles
LANGUAGES = [
    ('es', _('Español')),
    ('en', _('English')),
]


# Ruta para los archivos de traducción
LOCALE_PATHS = [
    BASE_DIR / 'locale/',  # Ajusta según tu estructura
]

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.2/howto/static-files/

STATIC_URL = "/static/"

# Cambia esta línea para que sea una lista
STATICFILES_DIRS = [
    os.path.join(BASE_DIR, 'static/'),  # Cambia esto si es necesario
]

STATIC_ROOT = "/home/agricarm.com/public_html/agroapp/staticfiles/"  # new

STATICFILES_STORAGE = "django.contrib.staticfiles.storage.StaticFilesStorage"


# Ruta relativa donde se guardarán los archivos subidos por CKEditor
CKEDITOR_UPLOAD_PATH = "uploads/"

# Asegúrate de que tengas configurado MEDIA_ROOT y MEDIA_URL en tu settings.py
MEDIA_ROOT = os.path.join(BASE_DIR, 'media/')
MEDIA_URL = '/media/'

# Default primary key field type
# https://docs.djangoproject.com/en/5.0/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


# CONFIG ENVIO DE EMAILS
EMAIL_BACKEND = "django.core.mail.backends.smtp.EmailBackend"

EMAIL_HOST = 'smtp.mailersend.net'
EMAIL_PORT = 587
EMAIL_USE_TLS = True
EMAIL_HOST_USER = 'MS_7zJViU@agricarm.com'
EMAIL_HOST_PASSWORD = '6RfATrSaXNDZranw'
DEFAULT_FROM_EMAIL = 'no-reply@agricarm.com'

MAILCHIMP_API_KEY = '1bcd8f1cd5846631cb1201ac956aabe9-us11'  # Reemplaza con tu API Key
MAILCHIMP_SERVER_PREFIX = 'us11'  # Ejemplo: us21
MAILCHIMP_LIST_ID = '6fab3498b6'  # ID de tu lista (Audience ID)
