# scouts/urls.py

from django.urls import path
from . import views
from .views import *
from .views import subscribe_mailchimp

urlpatterns = [
    # Autenticación y gestión de usuarios
    path('login/', login_request, name='login'),
    path('registro/', register, name='register'),
    path('verificar/', verify_token, name='verify'),
    path('logout/', logout_view, name='logout'),

    # Gestión de campos (fields)
    path('fields/', views.fieldlistcreate, name='field-list'),
    path('fields/edit/<int:field_id>/', edit_field, name='edit-field'),
    path('fields/delete/<int:field_id>/', delete_field, name='delete-field'),
    path('fields/<int:field_id>/', field_detail, name='field-detail'),
    path('fields/<int:field_id>/weather/', get_weather, name='field-weather'),
    path('fields/area-comparison/', views.field_area_comparison, name='field-area-comparison'),
    path('fields/climate-analysis/', views.field_climate_analysis, name='field-climate-analysis'),
    path('fields/soil-type-distribution/', views.soil_type_distribution, name='soil-type-distribution'),
    path('fields/<int:field_id>/crop_distribution/', views.crop_distribution_data, name='crop-distribution-data'),
    path('fields/size_comparison/', field_size_comparison_view, name='field-size-comparison'),
    path('fields/<int:field_id>/crop-types-data/', views.get_crop_types_data, name='field-crop-types-data'),
    path('fields/<int:field_id>/growth-trend-data/', views.get_growth_trend_data, name='field-growth-trend-data'),
    path('fields/<int:field_id>/soil-climate-data/', views.get_soil_climate_data, name='field-soil-climate-data'),

    # Gestión de pruebas de suelo (soil tests)
    path('fields/<int:field_id>/soil-tests/', views.soil_test_list, name='scout-soil-test-list'),
    path('fields/<int:field_id>/soil-tests/add/', views.add_soil_test, name='scout-add-soil-test'),

    # Gestión de cultivos (crops)
    path('crops/', crop_list, name='crop-list'),
    path('crops/edit/<int:crop_id>/', edit_crop, name='edit-crop'),
    path('crops/delete/<int:crop_id>/', delete_crop, name='delete-crop'),
    path('crops/<int:crop_id>/growth-data/', views.crop_growth_data, name='crop-growth-data'),
    path('crops/<int:crop_id>/', views.crop_detail, name='crop-detail'),
    path('crops/type-distribution/', views.crop_type_distribution, name='crop-type-distribution'),
    path('crops/harvest-date-distribution/', views.harvest_date_distribution, name='harvest-date-distribution'),
    path('crops/<int:crop_id>/plant-count-history/', get_plant_count_history, name='plant-count-history'),

    # Gestión de observaciones (observations)
    path('observation/<int:crop_id>/create/', views.create_observation, name='create-observation'),
    path('observation/<int:observation_id>/edit/', views.edit_observation, name='edit-observation'),
    path('observation/<int:observation_id>/delete/', views.delete_observation, name='delete-observation'),

    # Recomendaciones y notificaciones
    path('recommendations/', views.recommendations_view, name='recommendations_view'),
    path('notifications/mark-all-read/', mark_all_read, name='mark_all_read'),

    # Otras URLs
    path('create-crop/', create_crop, name='create-crop'),
    path('count-plants/', count_plants, name='count_plants'),
    path('scout/<int:scout_id>/edit/', views.edit_scout_profile, name='edit_scout_profile'),
    path('subscribe/', views.subscribe_mailchimp, name='subscribe_mailchimp'),

    # Post Sociales
    path('social/posts/', views.post_list, name='post_list'),
    path('social/posts/add/', views.create_post, name='create_post'),
    path('social/posts/edit/<int:post_id>/', views.edit_post, name='edit_post'),
    path('social/posts/delete/<int:post_id>/', views.delete_post, name='delete_post'),
    path('social/posts/comment/<int:post_id>/', views.add_comment, name='add_comment'),
    path('social/comments/edit/<int:comment_id>/', views.edit_comment, name='edit_comment'),
    path('social/comments/delete/<int:comment_id>/', views.delete_comment, name='delete_comment'),

    path('recursos/', views.recursos_scouts, name='recursos_scouts'),
    path('curso-agricultura/', agriculture_course_view, name='agriculture_course'),

]