# scouts/middleware.py
from django.utils.deprecation import MiddlewareMixin
from scouts.models import Token


class TokenAuthMiddleware(MiddlewareMixin):
    def process_request(self, request):
        token = request.headers.get('Authorization')
        if token:
            try:
                token = token.replace('Token ', '')
                valid_token = Token.objects.get(
                    token=token, expires_at__gte=timezone.now())
                request.user = valid_token.scout
            except Token.DoesNotExist:
                request.user = None
        else:
            request.user = None
