from django.contrib import admin
from .models import Scout, Field, Crop, CropObservation, Recommendation, Brand


@admin.register(Scout)
class ScoutAdmin(admin.ModelAdmin):
    list_display = ('first_name', 'last_name', 'email', 'phone', 'user_type')
    search_fields = ('first_name', 'last_name', 'email')
    list_filter = ('user_type',)


@admin.register(Field)
class FieldAdmin(admin.ModelAdmin):
    list_display = ('name', 'location', 'size',
                    'soil_type')  # Remover 'current_crop'
    list_filter = ('location', 'soil_type')  # Remover 'current_crop'
    search_fields = ('name',)


@admin.register(Crop)
class CropAdmin(admin.ModelAdmin):
    list_display = ('name', 'crop_type')  # Remover 'season'
    list_filter = ('crop_type',)  # Remover 'season'
    search_fields = ('name',)


@admin.register(CropObservation)
class CropObservationAdmin(admin.ModelAdmin):
    list_display = ('crop', 'date', 'stand_count',
                    'crop_height')  # Cambiar 'field' a 'crop'
    list_filter = ('crop', 'date')  # Cambiar 'field' a 'crop'
    raw_id_fields = ('crop',)  # Cambiar 'field' a 'crop'
    search_fields = ('crop__name',)


@admin.register(Recommendation)
class RecommendationAdmin(admin.ModelAdmin):
    list_display = ('title', 'created_at', 'crop_observation', 'brand')
    search_fields = ('title', 'description')
    list_filter = ('created_at', 'brand')
    raw_id_fields = ('crop_observation',)
    autocomplete_fields = ('brand',)


@admin.register(Brand)
class BrandAdmin(admin.ModelAdmin):
    list_display = ('name', 'website', 'contact_info')
    search_fields = ('name',)
    list_filter = ('name',)
