from django.urls import path
from . import views
from .views import *


urlpatterns = [

    # Dashboard del finquero
    path('farmer/dashboard/', views.farmer_dashboard, name='farmer_dashboard'),
    path('farmer/machinery-fuel-data/', machinery_fuel_consumption_data, name='machinery-fuel-data'),

    # Gestión de Scouts
    path('farmer/scouts/manage/', views.manage_scouts, name='manage_scouts'),
    path('farmer/scouts/assign/<int:scout_id>/', views.assign_scout, name='assign-scout'),
    path('farmer/scouts/unassign/<int:scout_id>/', views.unassign_scout, name='unassign-scout'),

    # Gestión de Campos
    path('farmer/fields/manage/', views.farmer_field_list, name='farmer-field-list'),
    path('farmer/fields/<int:field_id>/', views.farmer_field_detail, name='farmer-field-detail'),
    path('farmer/fields/create/', views.create_field, name='farmer-create-field'),
    path('farmer/fields/edit/<int:field_id>/', views.edit_field, name='farmer-edit-field'),
    path('farmer/fields/delete/<int:field_id>/', views.delete_field, name='farmer-delete-field'),

    # Gestión de Cultivos
    path('farmer/crops/manage/', views.farmer_crop_list, name='farmer-crop-list'),
    path('farmer/crops/<int:crop_id>/', views.farmer_crop_detail, name='farmer-crop-detail'),
    path('farmer/crops/create/', views.create_crop, name='farmer-create-crop'),
    path('farmer/crops/edit/<int:crop_id>/', views.edit_crop, name='farmer-edit-crop'),
    path('farmer/crops/delete/<int:crop_id>/', views.delete_crop, name='farmer-delete-crop'),

    path('farmer/crops/<int:crop_id>/observation/create/', views.create_observation, name='farmer-create-observation'),
    path('farmer/observations/edit/<int:observation_id>/', views.edit_observation, name='farmer-edit-observation'),
    path('farmer/observations/delete/<int:observation_id>/', views.delete_observation, name='farmer-delete-observation'),

    # Gestión de scouts
    path('farmer/scouts/search/', search_scouts, name='search-scouts'),
    path('farmer/fields/<int:field_id>/crop-types-data/', farmer_field_crop_types_data, name='farmer-field-crop-types-data'),

    # # Gestión de campos
    path('farmer/fields/area-comparison/', views.field_area_comparison_farmer, name='farmer-field-area-comparison'),
    path('farmer/fields/climate-analysis/', views.field_climate_analysis_farmer, name='farmer-field-climate-analysis'),
    path('farmer/fields/soil-type-distribution/', views.soil_type_distribution_farmer, name='farmer-soil-type-distribution'),

    # # Gestión de cultivos
    path('farmer/crops/type-distribution/', views.farmer_crop_type_distribution, name='farmer-crop-type-distribution'),
    path('farmer/crop/<int:crop_id>/growth-data/', get_growth_trend_data, name='farmer-crop-growth-data'),
    path('farmer/field/<int:field_id>/soil-climate-data/', get_soil_climate_data, name='farmer-soil-climate-data'),

    path('farmer/crops/production-by-type/', estimated_production_by_crop_type, name='farmer-crop-production-by-type'),
    path('farmer/crops/income-by-type/', estimated_income_by_crop_type, name='farmer-crop-income-by-type'),

    path('farmer/recommendations/', views.farmer_recommendations, name='farmer-recommendations'),

    path('farmer/fields/<int:field_id>/soil-tests/', views.soil_test_list, name='farmer-soil-test-list'),
    path('farmer/fields/<int:field_id>/soil-tests/add/', views.add_soil_test, name='farmer-add-soil-test'),

    # Gestión de Maquinaria
    path('farmer/machinery/manage/', manage_machinery, name='manage-machinery'),
    path('farmer/machinery/edit/<int:machinery_id>/', views.edit_machinery, name='edit-machinery'),
    path('farmer/machinery/delete/<int:machinery_id>/', views.delete_machinery, name='delete-machinery'),
    path("farmer/machinery/data/", views.manage_machinery_data, name="manage_machinery_data"),
    path("farmer/machinery/data/create/", create_machinery_data, name="create_machinery_data"),
    path("farmer/machinery/data/delete/<int:pk>/", views.delete_machinery_data, name="delete_machinery_data"),
    path("farmer/machinery/data/update/<int:data_id>/", update_machinery_data, name="update_machinery_data"),

    path("farmer/expenses/", manage_expenses, name="manage_expenses"),
    path("farmer/expenses/create/", create_expense, name="create_expense"),
    path("farmer/expenses/edit/<int:pk>/", edit_expense, name="edit_expense"),
    path("farmer/expenses/delete/<int:pk>/", delete_expense, name="delete_expense"),

    # Proyección de Ganancias
    path('farmer/projected-gains/', projected_gains_view, name='projected-gains'),
    path('farmer/projected-gains-chart/', projected_gains_chart_data, name='projected-gains-chart'),

    # Reportes
    path('farmer/reports/', report_list, name='farmer-reports'),
    path('farmer/reports/download/<str:report_type>/', generate_report, name='generate-report'),


    path('farmer/<int:farmer_id>/edit/', views.edit_farmer_profile, name='edit_farmer_profile'),

    path('farmer/notifications/mark-all-read/', views.mark_all_read_farmer, name='farmer-mark-all-read'),


    # Post Sociales
    path('farmer/posts/', views.post_list, name='post_list'),
    path('farmer/posts/add/', views.create_post, name='create_post'),
    path('farmer/posts/edit/<int:post_id>/', views.edit_post, name='edit_post'),
    path('farmer/posts/delete/<int:post_id>/', views.delete_post, name='delete_post'),
    path('farmer/posts/comment/<int:post_id>/', views.add_comment, name='add_comment'),
    path('farmer/comments/edit/<int:comment_id>/', views.edit_comment, name='edit_comment'),
    path('farmer/comments/delete/<int:comment_id>/', views.delete_comment, name='delete_comment'),

    path('farmer/recursos/', views.recursos_farmer, name='recursos_farmer'),
    path('farmer/curso-agricultura/', agriculture_course_view, name='agriculture_course'),

]
