# Generated by Django 5.0.6 on 2025-03-11 03:29

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('scouts', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='Farmer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('phone', models.CharField(blank=True, max_length=15, null=True)),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('profile_picture', models.ImageField(blank=True, null=True, upload_to='profile_pictures/')),
            ],
        ),
        migrations.CreateModel(
            name='Expense',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('expense_type', models.CharField(choices=[('fertilizer', 'Fertilizante'), ('pesticide', 'Pesticida'), ('repair', 'Reparación de Equipos'), ('labor', 'Mano de Obra'), ('other', 'Otro')], max_length=50)),
                ('description', models.CharField(max_length=255)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('date', models.DateField()),
                ('notes', models.TextField(blank=True, null=True)),
                ('farmer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='expenses', to='farmer.farmer')),
            ],
        ),
        migrations.CreateModel(
            name='Machinery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Nombre')),
                ('machinery_type', models.CharField(choices=[('tractor', 'Tractor'), ('combine', 'Cosechadora'), ('plow', 'Arado'), ('sprayer', 'Pulverizador'), ('seeder', 'Sembradora'), ('irrigation', 'Sistema de Riego'), ('other', 'Otro')], max_length=50, verbose_name='Tipo de Maquinaria')),
                ('purchase_date', models.DateField(verbose_name='Fecha de Compra')),
                ('condition', models.CharField(max_length=50, verbose_name='Condición')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Descripción')),
                ('assigned_to', models.ForeignKey(blank=True, help_text='Indica quién tiene asignada la maquinaria. Déjelo en blanco si está en bodega.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assigned_machinery', to='scouts.scout', verbose_name='Asignado a')),
                ('farmer', models.ForeignKey(help_text='El propietario de la maquinaria.', on_delete=django.db.models.deletion.CASCADE, related_name='machineries', to='farmer.farmer', verbose_name='Finquero')),
            ],
        ),
        migrations.CreateModel(
            name='MachineryData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fuel_consumption', models.FloatField(help_text='Consumo de combustible en litros por hora')),
                ('operating_hours', models.FloatField(help_text='Horas de operación')),
                ('date', models.DateField()),
                ('notes', models.TextField(blank=True, null=True)),
                ('machinery', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='machinery_data', to='farmer.machinery')),
            ],
        ),
    ]
