# forms.py en la app Farmer
from django import forms
from .models import Machinery, MachineryData, Expense, Farmer


class MachineryForm(forms.ModelForm):
    class Meta:
        model = Machinery
        fields = [
            'name',
            'machinery_type',
            'purchase_date',
            'condition',
            'description',
            'assigned_to'
        ]
        widgets = {
            'purchase_date': forms.DateInput(attrs={'type': 'date'}),
            'description': forms.Textarea(attrs={'rows': 3}),
        }

    def __init__(self, *args, farmer=None, **kwargs):
        super().__init__(*args, **kwargs)
        if farmer:
            self.fields['assigned_to'].queryset = Scout.objects.filter(
                farmer=farmer)


class MachineryDataForm(forms.ModelForm):
    class Meta:
        model = MachineryData
        fields = ['machinery', 'fuel_consumption',
                  'operating_hours', 'date', 'notes']
        widgets = {
            'date': forms.DateInput(attrs={'type': 'date'}),
            'notes': forms.Textarea(attrs={'rows': 3}),
        }


class ExpenseForm(forms.ModelForm):
    class Meta:
        model = Expense
        fields = ["expense_type", "description", "amount", "date", "notes"]
        widgets = {
            "date": forms.DateInput(attrs={"type": "date", "class": "form-control"}),
            "expense_type": forms.Select(attrs={"class": "form-control"}),
            "description": forms.TextInput(attrs={"class": "form-control"}),
            "amount": forms.NumberInput(attrs={"class": "form-control"}),
            "notes": forms.Textarea(attrs={"class": "form-control", "rows": 3}),
        }


class FarmerProfileForm(forms.ModelForm):
    class Meta:
        model = Farmer
        fields = ['first_name', 'last_name', 'email',
                  'phone', 'address', 'profile_picture']
