from django.urls import path
from . import views
from .views import *
from .views import admin_recommendation_dashboard, get_problem_trends, get_recommendation_summary

urlpatterns = [

    # Dashboard del Agrónomo
    path('agronomist/dashboard/', views.agronomist_dashboard,
         name='agronomist-dashboard'),

    # Endpoints para gráficos
    path('agronomist/dashboard/scout-performance/',
         views.scout_performance_data, name='scout-performance-data'),
    path('agronomist/dashboard/recent-observations/',
         views.recent_observations_data, name='recent-observations-data'),
    path('agronomist/dashboard/detected-problems/',
         views.detected_problems_data, name='detected-problems-data'),

    path('agronomist/scouts/', views.scout_list, name='admin-scout-list'),
    path('agronomist/farmer/<int:farmer_id>/details/',
         views.farmer_details, name='admin-farmer-details'),

    path('agronomist/news/', news_list, name='news-list'),
    path('agronomist/news/create/', news_create, name='news-create'),
    path('agronomist/news/update/<int:pk>/', news_update, name='news-update'),
    path('agronomist/news/delete/<int:pk>/', news_delete, name='news-delete'),

    path('agronomist/admin-scouts/', views.scout_list, name='scout-list'),
    path('agronomist/admin-scouts/create/',
         views.scout_create, name='scout-create'),
    path('agronomist/admin-scouts/update/<int:pk>/',
         views.scout_update, name='scout-update'),
    path('agronomist/admin-scouts/delete/<int:pk>/',
         views.scout_delete, name='scout-delete'),

    path('agronomist/admin-posts/', post_list, name='post-list'),
    path('agronomist/admin-posts/create/', post_create, name='post-create'),
    path('agronomist/admin-posts/<int:post_id>/update/',
         post_update, name='post-update'),
    path('agronomist/admin-posts/<int:post_id>/delete/',
         post_delete, name='post-delete'),
    path('agronomist/admin-posts/<int:post_id>/comments/',
         views.load_comments, name='load-comments'),
    path('agronomist/admin-posts/<int:post_id>/comments/create/',
         comment_create, name='comment-create'),
    path('agronomist/admin-comments/<int:comment_id>/update/',
         comment_update, name='comment-update'),
    path('agronomist/admin-comments/<int:comment_id>/delete/',
         comment_delete, name='comment-delete'),

    path('agronomist/recommendations/', views.recommendations_dashboard,
         name='recommendations-dashboard'),
    path('agronomist/recommendations/crop-data/',
         views.crop_data_for_recommendations, name='recommendations-crop-data'),
    path('agronomist/recommendations/create/',
         views.create_recommendation, name='create-recommendation'),

    path('agronomist/reports/', views.general_reports_list,
         name='general-reports-list'),
    path('agronomist/reports/crops/',
         views.general_crop_report, name='general-crop-report'),
    path('agronomist/reports/scouts/',
         views.general_scout_report, name='general-scout-report'),

    path('agronomist/profile/edit/', views.edit_agronomist_profile,
         name='edit-agronomist-profile'),


]
