from django.urls import path
from . import views
from .views import *

urlpatterns = [

    # Dashboard del Agrónomo
    path('agronomist/dashboard/', views.agronomist_dashboard, name='agronomist-dashboard'),

    # Endpoints para gráficos
    path('agronomist/dashboard/scout-performance/', views.scout_performance_data, name='scout-performance-data'),
    path('agronomist/dashboard/recent-observations/', views.recent_observations_data, name='recent-observations-data'),
    path('agronomist/dashboard/detected-problems/', views.detected_problems_data, name='detected-problems-data'),

    # Gestión de Scouts y Farmers
    path('agronomist/scouts/', views.scout_list, name='admin-scout-list'),
    path('agronomist/farmer/<int:farmer_id>/details/', views.farmer_details, name='admin-farmer-details'),

    # Recomendaciones
    path('agronomist/recommendations/', views.recommendations_dashboard, name='recommendations-dashboard'),
    path('agronomist/recommendations/data/', views.recommendations_dashboard_data, name='recommendations-dashboard-data'),
    path('agronomist/recommendations/<int:recommendation_id>/', views.get_recommendation, name='get-recommendation'),
    path("agronomist/recommendations/update/<int:recommendation_id>/", update_recommendation, name="update_recommendation"),
    path('recommendation/delete/<int:recommendation_id>/', delete_recommendation, name='delete_recommendation'),


    path("agronomist/brands/", brand_list, name="brand-list"),
    path("agronomist/brands/create/", brand_create, name="brand-create"),
    path("agronomist/brands/update/<int:brand_id>/", brand_update, name="brand-update"),
    path("agronomist/brands/delete/<int:brand_id>/", brand_delete, name="brand-delete"),

    # Noticias
    path('agronomist/news/', views.news_list, name='news-list'),
    path('agronomist/news/create/', views.news_create, name='news-create'),
    path('agronomist/news/update/<int:pk>/', views.news_update, name='news-update'),
    path('agronomist/news/delete/<int:pk>/', views.news_delete, name='news-delete'),

    # Reportes Generales
    path('agronomist/reports/', views.general_reports_list, name='general-reports-list'),
    path('agronomist/reports/download/crops/', views.general_crop_report, name='general-crop-report'),
    path('agronomist/reports/download/scouts/', views.general_scout_report, name='general-scout-report'),

    # Perfil del Agrónomo
    path('agronomist/profile/edit/', views.edit_agronomist_profile, name='edit-agronomist-profile'),


    # Post Sociales
    path('agronomist/posts/', views.post_list, name='post_list'),
    path('agronomist/posts/add/', views.create_post, name='create_post'),
    path('agronomist/posts/edit/<int:post_id>/', views.edit_post, name='edit_post'),
    path('agronomist/posts/delete/<int:post_id>/', views.delete_post, name='delete_post'),
    path('agronomist/posts/comment/<int:post_id>/', views.add_comment, name='add_comment'),
    path('agronomist/comments/edit/<int:comment_id>/', views.edit_comment, name='edit_comment'),
    path('agronomist/comments/delete/<int:comment_id>/', views.delete_comment, name='delete_comment'),

    # Biblioteca
    path('agronomist/resources/', views.resource_dashboard, name='resource_dashboard'),

    path('agronomist/resources/book/', views.create_or_update_book, name='create_or_update_book'),
    path('agronomist/resources/book/delete/<int:pk>/', views.delete_book, name='delete_book'),

    path('agronomist/resources/video/', views.create_or_update_video, name='create_or_update_video'),
    path('agronomist/resources/video/delete/<int:pk>/', views.delete_video, name='delete_video'),

]
