from django import forms
from social.models import News
from scouts.models import Scout, Brand
from agronomist.models import Agronomist
from django.utils.translation import gettext as _


class NewsForm(forms.ModelForm):
    class Meta:
        model = News
        fields = ['title', 'content']

    # Asegúrate de incluir este campo si estás pasando el autor desde la plantilla
    author = forms.CharField(widget=forms.HiddenInput(), required=False)


class ScoutForm(forms.ModelForm):
    class Meta:
        model = Scout
        fields = ['first_name', 'last_name', 'email', 'phone',
                  'address', 'user_type', 'profile_picture']


class AgronomistProfileForm(forms.ModelForm):
    class Meta:
        model = Agronomist
        fields = ['first_name', 'last_name',
                  'email', 'phone', 'profile_picture']
        widgets = {
            'first_name': forms.TextInput(attrs={'class': 'form-control', 'placeholder': _('Nombre')}),
            'last_name': forms.TextInput(attrs={'class': 'form-control', 'placeholder': _('Apellido')}),
            'email': forms.EmailInput(attrs={'class': 'form-control', 'placeholder': _('Correo Electrónico')}),
            'phone': forms.TextInput(attrs={'class': 'form-control', 'placeholder': _('Teléfono')}),
            'profile_picture': forms.ClearableFileInput(attrs={'class': 'form-control'}),
        }


class BrandForm(forms.ModelForm):
    class Meta:
        model = Brand
        fields = ["name", "description", "website", "contact_info",
                  "product_type", "price_per_unit", "unit_of_measure", "availability"]
        labels = {
            "name": _("Nombre"),
            "description": _("Descripción"),
            "website": _("Sitio Web"),
            "contact_info": _("Información de Contacto"),
            "product_type": _("Tipo de Producto"),
            "price_per_unit": _("Precio por Unidad"),
            "unit_of_measure": _("Unidad de Medida"),
            "availability": _("Disponibilidad"),
        }
        widgets = {
            "description": forms.Textarea(attrs={"rows": 3}),
            "availability": forms.CheckboxInput(),
        }
