from django.conf.urls.i18n import i18n_patterns
from django.urls import path, include
from django.contrib import admin
from django.conf import settings
from django.conf.urls.static import static
from django.views.generic import TemplateView
from scouts.views import dashboard
from scouts.views import crop_growth_chart 

urlpatterns = [
    path('ckeditor/', include('ckeditor_uploader.urls')),  # Dejar sin prefijo
    path('set_language/', include('django.conf.urls.i18n')),  # URL para cambiar idioma
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)

urlpatterns += i18n_patterns(
    path('admin/', admin.site.urls),
    path('dashboard/', dashboard, name='dashboard'),
    path('dashboard/crop-growth-chart/', crop_growth_chart, name='crop_growth_chart'),
    path('', TemplateView.as_view(template_name='index.html'), name='landing-page'),
    
    path('', include('scouts.urls')),
    
    # path('', include('admin_dashboard.urls')),

    path('', include('farmer.urls')),

    path('', include('agronomist.urls')),

    path('social/', include('social.urls')),
)