from scouts.models import Scout, Notification
from farmer.models import Farmer
from agronomist.models import Agronomist

def current_user_context(request):
    """
    Proporciona el usuario actual (scout, farmer o agronomist) al contexto global de la plantilla.
    """
    scout_id = request.session.get('scout_id')
    farmer_id = request.session.get('farmer_id')
    agronomist_id = request.session.get('agronomist_id')

    current_user = None

    if scout_id:
        current_user = Scout.objects.filter(id=scout_id).first()
    elif farmer_id:
        current_user = Farmer.objects.filter(id=farmer_id).first()
    elif agronomist_id:
        current_user = Agronomist.objects.filter(id=agronomist_id).first()

    return {
        'current_user': current_user,
        'current_user_type': (
            'scout' if scout_id else 
            'farmer' if farmer_id else 
            'agronomist' if agronomist_id else None
        )
    }


def notifications_context(request):
    
    scout_id = request.session.get('scout_id')
    
    notifications = Notification.objects.filter(scout_id=scout_id, status='unread').order_by('-notification_date')[:10]  # Limitar a las 10 más recientes
    
    return {'notifications': notifications}
    
    return {}