from functools import wraps
from django.shortcuts import redirect
from agronomist.models import Agronomist
from farmer.models import Farmer
from scouts.models import Scout

def user_required(user_type):
    def decorator(view_func):
        @wraps(view_func)
        def _wrapped_view(request, *args, **kwargs):
            user_id = None
            user = None
            
            if user_type == 'scout':
                user_id = request.session.get('scout_id')
                if user_id:
                    user = Scout.objects.filter(id=user_id).first()
            elif user_type == 'farmer':
                user_id = request.session.get('farmer_id')
                if user_id:
                    user = Farmer.objects.filter(id=user_id).first()
            elif user_type == 'agronomist':
                user_id = request.session.get('agronomist_id')
                if user_id:
                    user = Agronomist.objects.filter(id=user_id).first()
            
            if not user:
                return redirect('login')

            return view_func(request, *args, **kwargs)  # No se pasa `user`

        return _wrapped_view
    return decorator
